# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Revert a publishing page to a previous version
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to SharePoint site
$webUrl = "http://sharepoint/site"

# Title of page
$title = "PowerShell Page"

# Version to restore
$versionLabel = "1.0"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint Site
$web = Get-SPWeb $webUrl
	
# Get the Publishing Site from the SharePoint Site
$pubWeb = [Microsoft.SharePoint.Publishing.PublishingWeb]::GetPublishingWeb($web)

# Create a CAML query to get the Page by its Title
$camlQuery = "<Where><Eq><FieldRef Name='Title'></FieldRef><Value Type='Text'>" + $title + "</Value></Eq></Where>"
	
# Get the Page with the CAML query
$page = $pubWeb.GetPublishingPages($camlQuery)

# Check out the Page
$page.ListItem.File.CheckOut()

# Revert the Page
$page.ListItem.Versions.RestoreByLabel($versionLabel)

# Check in the Page
$page.ListItem.File.CheckIn("Reverted to Version " + $versionLabel)

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 